<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($property['title']); ?></title>

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo e($property['title']); ?>" />
    <meta property="og:description" content="<?php echo e($property['bedroom']); ?> | <?php echo e($property['area']); ?> | <?php echo e($property['price']); ?>" />
    <meta property="og:image" content="<?php echo e($property['imagePaths'][0]); ?>" />
    <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
    <meta property="og:type" content="website" />

    <!-- Optional: Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="<?php echo e($property['title']); ?>" />
    <meta name="twitter:description" content="<?php echo e($property['bedroom']); ?> | <?php echo e($property['area']); ?> | <?php echo e($property['price']); ?>" />
    <meta name="twitter:image" content="<?php echo e($property['imagePaths'][0]); ?>" />
</head>
<body>
    <h1><?php echo e($property['title']); ?></h1>
    <p><?php echo e($property['bedroom']); ?> | <?php echo e($property['area']); ?> | <?php echo e($property['price']); ?></p>
    <img src="<?php echo e($property['imagePaths'][0]); ?>" alt="Property Image" style="max-width: 100%; height: auto;">
</body>
</html><?php /**PATH /Applications/MAMP/htdocs/ehome_web/property-og-demo/resources/views/property/show.blade.php ENDPATH**/ ?>